using System;
using Microsoft.DirectX;

using DarkStrideToolbox;


namespace MetalMarines
{
	public class DarkStrideIntro
	{
		#region Properties
		private const string m_cBMP_DSSHOOTER	= "DS Intro DarkStrider Shooter BMP";
		private const string m_cBMP_DSWALKER	= "DS Intro DarkStrider Walker BMP";
		private const string m_cBMP_DSMETAL		= "DS Intro Metal BMP";
		private const string m_cBMP_GREY		= "DS Intro Grey Fade BMP";
		private const string m_cMESH_HAMMER		= "DS Intro Hammer Mesh";
		private const string m_cMESH_DSTEXT		= "DS Intro Text Mesh";

		private bool m_bFadeStarted = false;
		private double m_nFadeAmount = 1;
		
		private bool m_bDoneWithIntro = false;
		private DSGraphicsWrapper m_oGraphicsWrapper = null;
		private double m_nIntroElapsedTime = 0;
		#endregion


		public DarkStrideIntro( DSGraphicsWrapper oGraphicsWrapper )
		{
			DSMesh oLoadingMesh = null;


			m_oGraphicsWrapper = oGraphicsWrapper;

			oLoadingMesh = new DSMesh( oGraphicsWrapper.Direct3DDevice );
			oLoadingMesh.CreateMeshText( "DarkStride Software",15,System.Drawing.Color.Red );
			DSResourceManager.GetGlobalInstance().LoadMesh( m_cMESH_DSTEXT,oLoadingMesh );
		}


		public void Advance( double nElapsedTime )
		{
			if( m_bDoneWithIntro == false )
			{
				m_nIntroElapsedTime += nElapsedTime;
			}

			if( m_nIntroElapsedTime > 4 )
			{
				m_bFadeStarted = true;
			}

			//Fade out the main menu			
			if( m_bFadeStarted == true )
			{
				m_nFadeAmount -= 1 * nElapsedTime;
				if( m_nFadeAmount < 0 )
				{
					m_nFadeAmount = 0;
					m_bDoneWithIntro = true;
				}
			}
		}
		public void Render3D()
		{
			/*DSMesh oLoadingMesh = null;
			Vector3 eyeLocation = new Vector3(0.0f,0*-5.0f,-20.0f);
			Vector3 lookAtPoint = new Vector3(1.0f, 0.0f,  0.0f);


			if( m_bDoneWithIntro == false )
			{
				m_oGraphicsWrapper.Direct3DDevice.Transform.View = Matrix.LookAtLH( eyeLocation, lookAtPoint, new Vector3(0,1,0 ) );
				m_oGraphicsWrapper.Direct3DDevice.Transform.Projection = Matrix.PerspectiveFovLH(.78f, 1, 1, 1000);

				//Between 2 seconds and 4 seconds draw the hammer descending
				if( m_nIntroElapsedTime >= 2 && m_nIntroElapsedTime < 4 )
				{
					oLoadingMesh = DSResourceManager.GetGlobalInstance().GetMesh( m_cMESH_HAMMER );
					oLoadingMesh.Render( Matrix.Identity );
				}
				//Between 4 and 6 seconds draw the hammer raising
				else if( m_nIntroElapsedTime >= 4 && m_nIntroElapsedTime < 6 )
				{
					oLoadingMesh = DSResourceManager.GetGlobalInstance().GetMesh( m_cMESH_HAMMER );
					oLoadingMesh.Render( Matrix.Identity );
				}

				//From 5 seconds and beyond draw the DS text
				if( m_nIntroElapsedTime > 5 )
				{
					oLoadingMesh = DSResourceManager.GetGlobalInstance().GetMesh( m_cMESH_DSTEXT );
					oLoadingMesh.Render( Matrix.Identity );
				}
			}*/
		}
		public void Render2DAfterForms()
		{
			System.Drawing.Rectangle oTrgRect = System.Drawing.Rectangle.Empty;
			LoadedTexture oLoadedTexture = null;


			if( m_bDoneWithIntro == false )
			{
				oLoadedTexture = DSResourceManager.GetGlobalInstance().GetLoadedTexture( m_cBMP_DSMETAL );

				m_oGraphicsWrapper.RenderTexture2D( m_cBMP_DSMETAL,
					System.Drawing.Rectangle.Empty,
					new System.Drawing.Rectangle( (int)( m_oGraphicsWrapper.ScreenWidth / 2 - oLoadedTexture.Size.X / 2 ),
												  (int)( m_oGraphicsWrapper.ScreenHeight / 2 - oLoadedTexture.Size.Y / 2 ),0,0),
					new Vector2(),0,
					0,false,System.Drawing.Color.White.ToArgb() );


				//Between 0 and 3 seconds draw the man walking
				/*if( m_nIntroElapsedTime < 3 )
				{
					m_oGraphicsWrapper.RenderTexture2D( m_cBMP_DSMETAL,
														System.Drawing.Rectangle.Empty,
														new System.Drawing.Rectangle( 250,200,0,0),
														new Vector2(),0,
														0,false,System.Drawing.Color.White.ToArgb() );
				}
				//Beyond 3 seconds draw the static man
				else
				{
					m_oGraphicsWrapper.RenderTexture2D( m_cBMP_DSSHOOTER,
														System.Drawing.Rectangle.Empty,
														System.Drawing.Rectangle.Empty,new Vector2(),0,
														0,false,System.Drawing.Color.White.ToArgb() );				
				}*/

				//Beyond 9 seconds fade the whole shabang out
				if( m_bFadeStarted == true )
				{
					//Why x2 you ask?  I don't know, its a bug I haven't had time to look into.  
					oTrgRect = new System.Drawing.Rectangle( 0,0,m_oGraphicsWrapper.ScreenWidth*2,m_oGraphicsWrapper.ScreenHeight*2 );
					m_oGraphicsWrapper.RenderTexture2D( m_cBMP_GREY,System.Drawing.Rectangle.Empty,oTrgRect,new Vector2(),0,
														m_nFadeAmount,false,System.Drawing.Color.Black.ToArgb() );
				}
			}
		}
		public void UserHitKey()
		{
			m_bFadeStarted = true;
		}



		#region Properties
		public bool DoneWithIntro
		{
			get
			{
				return( m_bDoneWithIntro );
			}
			set
			{
				m_bDoneWithIntro = value;
			}
		}
		#endregion
	}
}
